/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.init;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class ModTags {
    public static Map<ResourceLocation, TagKey<Block>> blockTagCache = new HashMap<ResourceLocation, TagKey<Block>>();
    public static Map<ResourceLocation, TagKey<Item>> itemTagCache = new HashMap<ResourceLocation, TagKey<Item>>();
    public static Map<ResourceLocation, TagKey<Fluid>> fluidTagCache = new HashMap<ResourceLocation, TagKey<Fluid>>();
    public static Map<ResourceLocation, TagKey<EntityType<?>>> entityTagCache = new HashMap();
    public static final TagKey<Block> SOLITARY_OVERWORLD_NESTS = ModTags.getBlockTag("solitary_overworld_nests");
    public static final TagKey<Block> REED_NESTS = ModTags.getBlockTag("nests/reed_nests");
    public static final TagKey<Block> COLD_NESTS = ModTags.getBlockTag("nests/cold_nests");
    public static final TagKey<Block> WOOD_NESTS = ModTags.getBlockTag("nests/wood_nests");
    public static final TagKey<Block> BUMBLE_BEE_NESTS = ModTags.getBlockTag("nests/bumble_bee");
    public static final TagKey<Block> FOREST_FLOWERS = ModTags.getBlockTag("flowers/forest_flowers");
    public static final TagKey<Block> ARID_FLOWERS = ModTags.getBlockTag("flowers/arid_flowers");
    public static final TagKey<Block> SWAMP_FLOWERS = ModTags.getBlockTag("flowers/swamp_flowers");
    public static final TagKey<Block> SNOW_FLOWERS = ModTags.getBlockTag("flowers/snow_flowers");
    public static final TagKey<Block> RIVER_FLOWERS = ModTags.getBlockTag("flowers/river_flowers");
    public static final TagKey<Block> QUARRY = ModTags.getBlockTag("flowers/quarry");
    public static final TagKey<Block> LUMBER = ModTags.getBlockTag("flowers/lumber");
    public static final TagKey<Block> POWDERY = ModTags.getBlockTag("flowers/powdery");
    public static final TagKey<EntityType<?>> RANCHABLES = ModTags.getEntityTag(new ResourceLocation("productivebees", "ranchables"));
    public static final TagKey<Fluid> HONEY = FluidTags.create((ResourceLocation)new ResourceLocation("forge", "honey"));

    public static TagKey<Block> getBlockTag(String name) {
        return ModTags.getBlockTag(new ResourceLocation("productivebees", name));
    }

    public static TagKey<Block> getBlockTag(ResourceLocation resourceLocation) {
        if (!blockTagCache.containsKey(resourceLocation)) {
            blockTagCache.put(resourceLocation, (TagKey<Block>)BlockTags.create((ResourceLocation)resourceLocation));
        }
        return blockTagCache.get(resourceLocation);
    }

    public static TagKey<Item> getItemTag(ResourceLocation resourceLocation) {
        if (!itemTagCache.containsKey(resourceLocation)) {
            itemTagCache.put(resourceLocation, (TagKey<Item>)ItemTags.create((ResourceLocation)resourceLocation));
        }
        return itemTagCache.get(resourceLocation);
    }

    public static TagKey<Fluid> getFluidTag(ResourceLocation resourceLocation) {
        if (!fluidTagCache.containsKey(resourceLocation)) {
            fluidTagCache.put(resourceLocation, (TagKey<Fluid>)FluidTags.create((ResourceLocation)resourceLocation));
        }
        return fluidTagCache.get(resourceLocation);
    }

    public static TagKey<EntityType<?>> getEntityTag(ResourceLocation name) {
        return TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)name);
    }

    public static TagKey<Biome> getBiomeTag(ResourceLocation name) {
        return TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)name);
    }

    public static class Forge {
        public static final TagKey<Item> HONEY_BUCKETS = ModTags.getItemTag(new ResourceLocation("forge", "buckets/honey"));
        public static final TagKey<Item> EGGS = ModTags.getItemTag(new ResourceLocation("forge", "eggs"));
        public static final TagKey<Item> FISHING_RODS = ModTags.getItemTag(new ResourceLocation("forge", "rods/fishing"));
        public static final TagKey<Item> WAX = ModTags.getItemTag(new ResourceLocation("forge", "wax"));
        public static final TagKey<Item> WITHER_SKULL_FRAGMENTS = ModTags.getItemTag(new ResourceLocation("forge", "fragments/wither_skull"));
        public static final TagKey<Item> SILICON = ModTags.getItemTag(new ResourceLocation("forge", "silicon"));
        public static final TagKey<Item> SOURCE_GEM = ModTags.getItemTag(new ResourceLocation("forge", "gems/source"));
    }
}

